--
-- This file contains both Oracle and SQL Server statements for remotely
-- accessing the other database through a linked server or via Oracle
-- Heterogeneous Services.
--

--
-- Adding a linked server to Oracle using transact-SQL
--


exec sp_addlinkedserver 
     @server     = 'ORACLE8I',
     @provider   = 'MSDAORA',
     @datasrc    = 'DEV',
     @srvproduct = 'A name description of the linked server'


exec sp_serveroption ORACLE8I, collation compatible, true
go

exec sp_serveroption ORACLE8I, data access, true
go

sp_addlinkedsrvlogin @rmtsrvname = ORACLE8I, 
                     @useself = false, 
                     @locallogin = sa, 
                     @rmtuser = system, 
                     @rmtpassword = password
go

sp_addlinkedsrvlogin @rmtsrvname = ORACLE8I, 
                     @useself = false, 
                     @locallogin = app_admin, 
                     @rmtuser = new_app_admin, 
                     @rmtpassword = app_pswd
go

sp_addlinkedsrvlogin @rmtsrvname = ORACLE8I, 
                     @useself = true, 
                     @locallogin = app_user
go

sp_addlinkedsrvlogin @rmtsrvname = ORACLE8I, 
                     @useself = false
go


--
-- examples of how to use OPENQUERY to select information from Oracle using a 
-- linked server
--

SELECT *
FROM OPENQUERY(ORACLE8I, 'SELECT * FROM SCOTT.EMP') 
go

--
-- In this example, you can query Oracle directly by supplying the connection
-- information without having to create a linked server.
--

SELECT a.*
FROM OPENROWSET('MSDAORA','DEV7';'SCOTT';'TIGER',
    'SELECT * FROM SCOTT.EMP') AS a
go


--
-- Once the heterogeneous services is installed and configured
-- you can access your SQL Server database by issuing the SELECT statement
-- directly or you can hide the syntax with the use of a synonym.
--


SELECT * FROM "dbo"."Employees"@MSOLEDB
;

CREATE SYNONYM MY_EMPLOYEES FOR "dbo"."Employees"@MSOLEDB
;


--
-- Once the gateway is established you can then use it in your procedures as
-- this example shows by checking the inventory for a part from a SQL Server 
-- database. If there are not enough on hand then the PL/SQL will send a request
-- to the SQL Server database to order more of a particular part
--


DECLARE
   part_num     number(10);
   qty_to_order number(5,0);
   qty_on_hand  number(5,0);

BEGIN

   part_num := 1289456;
   qty_to_order := 25;

   CHECK_INVENTORY@SQLGATEWAY(part_num, qty_to_order, qty_on_hand);

   if( qty_to_order < qty_on_hand ) then
      FILL_ORDER(part_num, qty_to_order);
   else
      ORDER_MORE_PARTS@SQLGATEWAY( part_num, qty_to_order );
   end if;

END;
/



